import type { FormatConfig } from "./connection";
import type { AudioWorkletConfig } from "../BaseConversation";
export type InputConfig = {
    preferHeadphonesForIosDevices?: boolean;
    inputDeviceId?: string;
};
export declare class Input {
    readonly context: AudioContext;
    readonly analyser: AnalyserNode;
    readonly worklet: AudioWorkletNode;
    inputStream: MediaStream;
    private mediaStreamSource;
    static create({ sampleRate, format, preferHeadphonesForIosDevices, inputDeviceId, workletPaths, libsampleratePath, }: FormatConfig & InputConfig & AudioWorkletConfig): Promise<Input>;
    private constructor();
    close(): Promise<void>;
    setMuted(isMuted: boolean): void;
    setInputDevice(inputDeviceId?: string): Promise<void>;
}
